from random import randint
from tkinter import Tk,Label,Entry,Button,StringVar
from PIL import Image

class Redim(Tk) :
    def __init__(self):
        Tk.__init__(self)
        self.n = 0
        self.compteur = 0
        self.precedent = 0
        self.label = [[0 for i in range(100)] for j in range(100)]
        self.pixel = []
        self.createWidget()

    def createWidget(self) :
        self.texte = Label(self,text='Nombre Pixels : ', bg='white')
        self.texte.grid(row=0, column=0,pady = 10)
        self.nombre = Entry(self, width=6 ,textvariable=StringVar())
        self.nombre.grid(row = 0, padx = 10, column = 1)
        self.valider = Button(self, text='Valider',padx = 10,command = self.pix)
        self.valider.grid(row = 0, column=2)
        self.calcul = Button(self, text='Calculer',padx = 10)
        self.calcul.grid(row = 1, column = 2)
        self.somme = Label(self)
        self.somme.grid(row = 2, column = 2)

    def affichage(self):
        # Effacement de l'ancien tableau des pixels si "Recommencer" cliqué
        if self.compteur > 1 :
            for i in range(self.n_precedent) :
                for j in range(self.n_precedent) :
                    self.label[i][j].destroy()
                    self.label[i][j] = 0
        self.n_precedent = self.n
        # Affichage du tableau des pixels avec Tkinter
        self.texte.grid(columnspan =  self.n)
        self.nombre.grid(column = self.n+1)
        self.valider.grid(column = self.n+2)
        self.calcul.configure(command = self.redimensionnement)
        self.calcul.grid(row = 1, column = self.n+2)
        self.somme.grid(row = 2, column = self.n+2)
        for i in range(self.n) :
            for j in range(self.n) :
                self.label[i][j] = Label(self,padx = 5,pady = 2,text= self.pixel[i][j])
                self.label[i][j].grid(row=i+1,column=j)

    def pix(self) :
        '''
            fonction appelée après click sur le bouton Valider ou Recommencer. Permet
            la création et l'affichage du tableau pixel et permet le lancement des calculs
            de recherche du chemin de plus faible poids (ftc "redimensionnement()")
        '''
        self.somme.configure(text = '' , bg='#f0f0f0' )
        self.compteur += 1
        self.valider.configure(text = 'Recommencer')
        # Création du tableau des pixels
        txt = self.nombre.get()
        if txt == "im" :
            im = Image.open('image.jpg')
            l, h = im.size
            self.n = l
            self.resultat = [0 for i in range(self.n)]
            del self.pixel[:]
            self.pixel = [[0 for i in range(self.n)] for j in range(self.n)]
            for x in range(l):
                for y in range(h):
                    r, v, b = im.getpixel((x, y))
                    g=(r+v+b)//3
                    self.pixel[y][x] = 256 - g
        else :
            self.n = int(self.nombre.get())
            if self.n > 40 : return
            self.resultat = [0 for i in range(self.n)]
            del self.pixel[:]
            for i in range(self.n) :
                self.pixel.append([randint(0,10) for j in range(self.n)])
        # Affichage
        self.affichage()


    def redWay(self) :
    # affichage du chemin et de la somme mini sur l'interface Tkinter
        somme_mini = 0
        for i in range(self.n) :
            j = self.resultat[i]
            self.label[i][j].configure(bg='red')
            somme_mini += self.pixel[i][j]
        message = 'Somme mini = '+str(somme_mini)
        self.somme.configure(text = message , bg='red' )

    def redimensionnement(self) :
        pass


